﻿// Podstawowe funkcje
// Dodaje wychwytywanie zdarzeń
function aaManageEvent(eventObj, event, eventHandler) {
   if (eventObj.addEventListener) {
      eventObj.addEventListener(event, eventHandler,false);
   } else if (eventObj.attachEvent) {
      event = "on" + event;
      eventObj.attachEvent(event, eventHandler);
   }
}


// Obsługa akordeonu
window.onload= function() {
    var divs = document.getElementsByTagName('div');

    for (var i = 0; i < divs.length; i++) {

       // Ustawienie obsługi kliknięcia na pasku nazwy
       if (divs[i].className == 'nameCollapsed') {
          aaManageEvent(divs[i],'click',Accordion.expandOrCollapse);

       // Przypisanie wysokości każdemu znacznikowi i zwinięcie go
       } else if (divs[i].className == 'elements') {
 
          // IE6.x obsługuje inaczej znaczniki zwrócone przez getElementsByTagName 
          // a clientHeight w ogóle w niej nie działa; wykorzystanie alternatywy - offsetHeight

          var height = divs[i].offsetHeight;
          divs[i].height = height;
          if (divs[i].id == "") divs[i].id = "div" + i;
          divs[i].style.height = "0";
      }
    }
}

// manage the accordion
var Accordion = { 

   // Dopasowanie wysokości
   adjustItem  : function(val, newItem) {
            document.getElementById(newItem).style.height=val + "px";
   },

   // Sprawdza, czy panel jest rozwinięty, czy zwinięty
   expandOrCollapse : function (evnt) {
            evnt = evnt ? evnt : window.event;
            var target = evnt.target ? evnt.target : evnt.srcElement;
            if (target.className == 'nameCollapsed') 
                 Accordion.expand(target);
            else
                 Accordion.collapse(target);
   },

   // Rozwija panel
   expand : function(target) {
            target.className = 'nameExpanded';
            // Sygnał przełączania
            var children = target.parentNode.childNodes;
            var panel;
            for (var i = 0; i < children.length; i++) {
              if (children[i].className == 'elements') {
                 panel = children[i];
                 break;
              }
            }
            var height = panel.height;

            //Określa stopień powiększenia stosując obliczoną wartość wysokości podzieloną przez licznik pętli, czyli 20
            var incr = height / 20;
            for (var i=0; i < 20; i++) {
              var val = (i+1) * incr;
              var func = "Accordion.adjustItem("+val+",'"+ panel.id +"')";
              setTimeout(func,(i+1)*30);
            }

   },
   
   // Zwija panel
   collapse : function (target) {
            target.className = 'nameCollapsed';
            // Sygnał przełączania
            var children = target.parentNode.childNodes;
            var panel;
            for (var i = 0; i < children.length; i++) {
              if (children[i].className == 'elements') {
                 panel = children[i];
                 break;
              }
            }
            var height = panel.height;

            // Określa stopień powiększenia stosując obliczoną wartość wysokości podzieloną przez licznik pętli, czyli 20
            var decr = height / 20;
            for (var i=0; i < 20; i++) {
              var val = height-(decr*(i+1));;
              var func = "Accordion.adjustItem("+val+",'"+ panel.id +"')";
              setTimeout(func,(i+1)*30);
            }
   }

 };


